/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.entity.data.INPCAnimation;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.animation.AnimationFrameConfig;
import noppes.npcs.client.model.animation.EmotionConfig;
import noppes.npcs.client.model.animation.EmotionFrame;
import noppes.npcs.client.model.animation.PartConfig;
import noppes.npcs.constants.EnumAnimationStages;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.AnimationHandler;
import noppes.npcs.entity.data.EmotionHandler;

public class DataAnimation
implements INPCAnimation {
    public final EntityLivingBase entity;
    private final AnimationHandler animationHandler;
    private final EmotionHandler emotionHandler;
    public final Map<EnumParts, Boolean> showParts = new HashMap<EnumParts, Boolean>();
    public final Map<EnumParts, Boolean> showArmorParts = new HashMap<EnumParts, Boolean>();
    public final Map<EnumParts, Boolean> showAWParts = new HashMap<EnumParts, Boolean>();

    public DataAnimation(EntityLivingBase main) {
        this.entity = main;
        this.animationHandler = new AnimationHandler(main);
        this.emotionHandler = new EmotionHandler(main);
        this.showParts.put(EnumParts.HEAD, true);
        this.showParts.put(EnumParts.BODY, true);
        this.showParts.put(EnumParts.ARM_RIGHT, true);
        this.showParts.put(EnumParts.ARM_LEFT, true);
        this.showParts.put(EnumParts.LEG_RIGHT, true);
        this.showParts.put(EnumParts.LEG_LEFT, true);
        this.showParts.put(EnumParts.CUSTOM, true);
        this.showAWParts.put(EnumParts.HEAD, true);
        this.showAWParts.put(EnumParts.BODY, true);
        this.showAWParts.put(EnumParts.ARM_RIGHT, true);
        this.showAWParts.put(EnumParts.ARM_LEFT, true);
        this.showAWParts.put(EnumParts.LEG_RIGHT, true);
        this.showAWParts.put(EnumParts.LEG_LEFT, true);
        this.showAWParts.put(EnumParts.CUSTOM, true);
        this.showArmorParts.put(EnumParts.HEAD, true);
        this.showArmorParts.put(EnumParts.BODY, true);
        this.showArmorParts.put(EnumParts.ARM_RIGHT, true);
        this.showArmorParts.put(EnumParts.ARM_LEFT, true);
        this.showArmorParts.put(EnumParts.LEG_RIGHT, true);
        this.showArmorParts.put(EnumParts.LEG_LEFT, true);
        this.showArmorParts.put(EnumParts.FEET_RIGHT, true);
        this.showArmorParts.put(EnumParts.FEET_LEFT, true);
        this.showArmorParts.put(EnumParts.CUSTOM, true);
    }

    public void resetShowParts() {
        this.showParts.replaceAll((k, v) -> true);
        this.showArmorParts.replaceAll((k, v) -> true);
    }

    public void resetShowAWParts() {
        this.showAWParts.replaceAll((k, v) -> true);
    }

    public void reset() {
        this.stopAnimation();
        this.stopEmotion();
        if (this.entity == null || !this.entity.func_70613_aW()) {
            return;
        }
        if (this.entity instanceof EntityPlayerMP) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_SET, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au(), this.save(new NBTTagCompound()));
        } else if (this.entity instanceof EntityNPCInterface) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_SET, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y(), this.save(new NBTTagCompound()));
        }
    }

    public void setRotationAnglesAnimation(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, float partialTicks) {
        this.animationHandler.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, partialTicks);
        if (this.animationHandler.currentFrame != null) {
            for (PartConfig part : this.animationHandler.currentFrame.parts.values()) {
                this.showParts.put(part.getEnumType(), part.isShow());
            }
            this.showArmorParts.put(EnumParts.HEAD, this.animationHandler.currentFrame.showHelmet);
            this.showArmorParts.put(EnumParts.BODY, this.animationHandler.currentFrame.showBody);
            this.showArmorParts.put(EnumParts.ARM_RIGHT, this.animationHandler.currentFrame.showBody);
            this.showArmorParts.put(EnumParts.ARM_LEFT, this.animationHandler.currentFrame.showBody);
            this.showArmorParts.put(EnumParts.LEG_RIGHT, this.animationHandler.currentFrame.showLegs);
            this.showArmorParts.put(EnumParts.LEG_LEFT, this.animationHandler.currentFrame.showLegs);
            this.showArmorParts.put(EnumParts.FEET_RIGHT, this.animationHandler.currentFrame.showFeets);
            this.showArmorParts.put(EnumParts.FEET_LEFT, this.animationHandler.currentFrame.showFeets);
        }
    }

    public void stopAnimation() {
        if (this.animationHandler.activeAnimation != null) {
            if (this.animationHandler.activeAnimation.hasEmotion()) {
                this.stopEmotion();
            }
            if (this.entity != null && this.entity.func_70613_aW()) {
                if (this.entity instanceof EntityPlayerMP) {
                    Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au());
                } else if (this.entity instanceof EntityNPCInterface) {
                    Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y());
                }
            }
        }
        if (!this.animationHandler.movementAnimation.isEmpty()) {
            this.animationHandler.movementAnimation.clear();
            Map<Integer, Integer> map = this.animationHandler.resetWalkAndStandAnimations();
            if (map == null) {
                map = new HashMap<Integer, Integer>();
            }
            if (this.entity instanceof EntityPlayerMP) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au(), map);
            } else if (this.entity instanceof EntityNPCInterface) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y(), map);
            }
        }
        this.animationHandler.stopAnimation();
    }

    public void stopEmotion() {
        if (this.entity != null && this.entity.func_70613_aW() && this.emotionHandler.activeEmotion != null) {
            if (this.entity instanceof EntityPlayerMP) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_STOP_EMOTION, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au());
            } else if (this.entity instanceof EntityNPCInterface) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_STOP_EMOTION, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y());
            }
        }
        this.emotionHandler.stopEmotion();
    }

    public boolean hasAnim(AnimationKind type) {
        return this.animationHandler.hasAnim(type);
    }

    public void load(NBTTagCompound compound) {
        this.animationHandler.load(compound);
        this.emotionHandler.load(compound);
    }

    public NBTTagCompound save(NBTTagCompound compound) {
        this.animationHandler.save(compound);
        this.emotionHandler.save(compound);
        return compound;
    }

    public boolean isAnimated() {
        return this.animationHandler.isAnimated();
    }

    public void updateTime() {
        this.animationHandler.updateTime();
        this.emotionHandler.updateTime();
    }

    public boolean isAnimated(AnimationKind ... types) {
        return this.animationHandler.isAnimated(types);
    }

    public void resetWalkAndStandAnimations() {
        if (this.entity == null || this.entity.field_70170_p.func_82737_E() % 20L != 0L) {
            return;
        }
        Map<Integer, Integer> map = this.animationHandler.resetWalkAndStandAnimations();
        if (this.entity.func_70613_aW() && map != null) {
            if (this.entity instanceof EntityPlayerMP) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au(), map);
            } else if (this.entity instanceof EntityNPCInterface) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y(), map);
            }
        }
    }

    public AnimationConfig tryRunAnimation(AnimationKind type) {
        AnimationConfig anim = this.animationHandler.selectAnimation(type);
        if (anim == null) {
            return null;
        }
        return this.tryRunAnimation(anim, type);
    }

    public AnimationConfig tryRunAnimation(AnimationConfig anim, AnimationKind type) {
        if (this.entity == null) {
            return null;
        }
        if (anim != null && anim.frames.isEmpty()) {
            anim = null;
        }
        if (anim == null && this.animationHandler.activeAnimation != null && !this.animationHandler.activeAnimation.type.isMovement()) {
            this.stopAnimation();
            return null;
        }
        anim = this.animationHandler.tryRunAnimation(anim, type);
        if (!this.entity.func_70613_aW()) {
            return anim;
        }
        if (anim == null) {
            if (this.entity instanceof EntityPlayerMP) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au());
            } else if (this.entity instanceof EntityNPCInterface) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y());
            }
        } else if (this.entity instanceof EntityPlayerMP) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_RUN_ANIMATION, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au(), anim.id, type.ordinal());
        } else if (this.entity instanceof EntityNPCInterface) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.ANIMATION_DATA_RUN_ANIMATION, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y(), anim.id, type.ordinal());
        }
        return anim;
    }

    public AnimationConfig getAnimation() {
        return this.animationHandler.activeAnimation;
    }

    public boolean getJump() {
        return this.animationHandler.isJump;
    }

    public void setJump(boolean bo) {
        this.animationHandler.isJump = bo;
    }

    public boolean getSwing() {
        return this.animationHandler.isSwing;
    }

    public void setSwing(boolean bo) {
        this.animationHandler.isSwing = bo;
    }

    public EnumAnimationStages getAnimationStage() {
        return this.animationHandler.stage;
    }

    public boolean getAnimationPartShow(int partId) {
        return this.animationHandler.currentFrame == null || !this.animationHandler.currentFrame.parts.containsKey(partId) || this.animationHandler.currentFrame.parts.get((Object)Integer.valueOf((int)partId)).show;
    }

    public Float[] getAnimationPartData(int partId) {
        return this.animationHandler.rotationAngles.get(partId);
    }

    public void loadBaseAnimations(Map<Object, Object> map) {
        this.animationHandler.loadBaseAnimations(map);
    }

    public AnimationFrameConfig getPreFrame() {
        return this.animationHandler.preFrame;
    }

    public void addAnimation(AnimationKind type, int id) {
        this.animationHandler.addAnimation(type, id);
    }

    public boolean removeAnimation(AnimationKind type, int id) {
        return this.animationHandler.removeAnimation(type, id);
    }

    public boolean hasAnimation(AnimationKind type, int id) {
        return this.animationHandler.hasAnimation(type, id);
    }

    public boolean canSetBaseRotationAngles() {
        return this.animationHandler.canSetBaseRotationAngles();
    }

    public boolean canBeAnimated() {
        return this.animationHandler.canBeAnimated();
    }

    public ItemStack getCurrentHeldStack(boolean isMainHand) {
        return this.animationHandler.getCurrentHeldStack(isMainHand);
    }

    public int getAnimationCurrentFrameID() {
        return this.animationHandler.getAnimationCurrentFrameID();
    }

    public int getAnimationNextFrameID() {
        return this.animationHandler.getAnimationNextFrameID();
    }

    public int getAnimationTicks() {
        return this.animationHandler.getAnimationTicks();
    }

    public int getAnimationSpeedTicks() {
        return this.animationHandler.getAnimationSpeedTicks();
    }

    public EmotionFrame getCurrentEmotionFrame() {
        return this.emotionHandler.currentFrame;
    }

    public EmotionConfig getActiveEmotion() {
        return this.emotionHandler.activeEmotion;
    }

    public int getBaseEmotionId() {
        return this.emotionHandler.baseEmotionId;
    }

    public void setBaseEmotionId(int emotionId) {
        this.emotionHandler.baseEmotionId = emotionId;
    }

    public long getStartEmotionTime() {
        return this.emotionHandler.startEmotionTime;
    }

    public Map<Integer, Float[]> getEmotionData() {
        return this.emotionHandler.rotationAngles;
    }

    public void setActiveEmotion(EmotionConfig emotion) {
        this.emotionHandler.activeEmotion = emotion;
    }

    public void tryRunEmotion(EmotionConfig emotion) {
        if (this.entity == null) {
            return;
        }
        if (emotion != null && emotion.frames.isEmpty()) {
            emotion = null;
        }
        if (emotion == null) {
            this.stopEmotion();
            return;
        }
        emotion = this.emotionHandler.tryRunEmotion(emotion);
        if (!this.entity.func_70613_aW()) {
            return;
        }
        if (emotion == null) {
            if (this.entity instanceof EntityPlayerMP) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.EMOTION_DATA_STOP_ANIMATION, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au());
            } else if (this.entity instanceof EntityNPCInterface) {
                Server.sendToAll(CustomNpcs.Server, EnumPacketClient.EMOTION_DATA_STOP_ANIMATION, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y());
            }
        } else if (this.entity instanceof EntityPlayerMP) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.EMOTION_DATA_RUN_ANIMATION, false, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_110124_au(), emotion.id);
        } else if (this.entity instanceof EntityNPCInterface) {
            Server.sendToAll(CustomNpcs.Server, EnumPacketClient.EMOTION_DATA_RUN_ANIMATION, true, this.entity.field_70170_p.field_73011_w.getDimension(), this.entity.func_145782_y(), emotion.id);
        }
    }

    public boolean isEmoted() {
        return this.emotionHandler.isAnimated();
    }

    public void setRotationAnglesEmotion(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, float partialTicks) {
        this.emotionHandler.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, partialTicks);
    }

    public boolean emotionIsDisableMoved() {
        if (this.emotionHandler.currentFrame == null) {
            return true;
        }
        return this.emotionHandler.currentFrame.disable;
    }

    public EmotionFrame getEmotionCurrentFrame() {
        return this.emotionHandler.currentFrame;
    }
}

